Ext.data.JsonP.sol_common_UserProfile({"tagname":"class","name":"sol.common.UserProfile","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.UserProfile.js","href":"lib_sol.common.UserProfile.html#sol-common-UserProfile"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.0"],"elojc":true,"eloas":true,"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"requiredProperties","tagname":"property","owner":"sol.common.UserProfile","id":"property-requiredProperties","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getOption","tagname":"method","owner":"sol.common.UserProfile","id":"method-getOption","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.UserProfile","id":"method-initialize","meta":{"private":true}},{"name":"read","tagname":"method","owner":"sol.common.UserProfile","id":"method-read","meta":{}},{"name":"setOption","tagname":"method","owner":"sol.common.UserProfile","id":"method-setOption","meta":{}},{"name":"write","tagname":"method","owner":"sol.common.UserProfile","id":"method-write","meta":{}}],"code_type":"ext_define","id":"class-sol.common.UserProfile","short_doc":"Represents the settings of an user\n\nvar userProfile = sol.create('sol.common.UserProfile', {\n   userId: \"123\"\n});\n\n//...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.UserProfile</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile' target='_blank'>lib_sol.common.UserProfile.js</a></div></pre><div class='doc-contents'><p>Represents the settings of an user</p>\n\n<pre><code>var userProfile = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('<a href=\"#!/api/sol.common.UserProfile\" rel=\"sol.common.UserProfile\" class=\"docClass\">sol.common.UserProfile</a>', {\n   userId: \"123\"\n});\n\n// get an option\nvar option = userProfile.getOption(\"Elo.J.S.Script.ELO.LastId\");\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-requiredProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserProfile'>sol.common.UserProfile</span><br/><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile-property-requiredProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserProfile-property-requiredProperties' class='name expandable'>requiredProperties</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;userId&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getOption' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserProfile'>sol.common.UserProfile</span><br/><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile-method-getOption' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserProfile-method-getOption' class='name expandable'>getOption</a>( <span class='pre'>key</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a single value of the user settings ...</div><div class='long'><p>Returns a single value of the user settings</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key of the user setting.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>single value of the user settings.</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserProfile'>sol.common.UserProfile</span><br/><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserProfile-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-read' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserProfile'>sol.common.UserProfile</span><br/><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile-method-read' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserProfile-method-read' class='name expandable'>read</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads the settings of an user ...</div><div class='long'><p>Reads the settings of an user</p>\n</div></div></div><div id='method-setOption' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserProfile'>sol.common.UserProfile</span><br/><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile-method-setOption' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserProfile-method-setOption' class='name expandable'>setOption</a>( <span class='pre'>key, value, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a profile option ...</div><div class='long'><p>Sets a profile option</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key of the user setting.</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>Key of the user setting.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>profile option.</p>\n</div></li></ul></div></div></div><div id='method-write' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.UserProfile'>sol.common.UserProfile</span><br/><a href='source/lib_sol.common.UserProfile.html#sol-common-UserProfile-method-write' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.UserProfile-method-write' class='name expandable'>write</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes the changed profile options ...</div><div class='long'><p>Writes the changed profile options</p>\n</div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true}});